<?php
/*
Plugin Name: RTL-Update | به روز رسان خودکار راست چین
Plugin URI: https://www.rtl-theme.com
Description: جدیدترین ورژن محصولات خریداری شده راست چین را به صورت خودکار از پیشخوان وردپرس دریافت کنید. علاوه بر این از آخرین هشدار های امنیتی وردپرس و اطلاعیه های راست چین زودتر از همه با خبر شوید.
Author: راست چین
Version: 1.2
Author URI: https://www.rtl-theme.com
Domain Path: /languages
Text Domain: rtl-theme
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

define( 'RTLTHEME_BASE_VERSION', 1.2 );
define( 'RTLTHEME_PLUGIN_PATH', plugin_dir_path(__FILE__) );
define( 'RTLTHEME_PLUGIN_URL', plugin_dir_url(__FILE__) );
define( 'RTLTHEME_PLUGIN_CSS', RTLTHEME_PLUGIN_URL . 'assets/css/' );
define( 'RTLTHEME_PLUGIN_JS', RTLTHEME_PLUGIN_URL . 'assets/js/' );

load_plugin_textdomain('rtl-theme', FALSE, dirname(plugin_basename(__FILE__)).'/languages/');

add_action( 'admin_enqueue_scripts', 'rtl_theme_admin_enqueue_scripts' );

function rtl_theme_admin_enqueue_scripts() {
	wp_enqueue_media();
	wp_enqueue_script( 'jquery' );
	wp_enqueue_style( 'rtl-theme-settings', RTLTHEME_PLUGIN_CSS . 'admin.css', '', '1.0', false );
}

spl_autoload_register(function ($class){
    $include = RTLTHEME_PLUGIN_PATH.'lib/'.strtolower($class).'.php';
    if ( file_exists($include) ) {
		require_once($include);
	}
},false);

if ( version_compare( phpversion(), '7.2', '>=') && extension_loaded('ionCube Loader') && ( function_exists('ioncube_loader_version') || version_compare( ioncube_loader_version(), '10.2', '>=') ) ) {
	RTL_Theme_class::instance();
} else {
	add_action('admin_notices', 'rtlt_run_error_message' );
}

function rtlt_run_error_message() {
	?>
	<div class="notice notice-error rtl-theme-notice">
		<img src="<?php echo RTLTHEME_PLUGIN_URL . '/assets/images/rtl-logo-small.png' ?>" />
		<div class="rtl-theme-notice-content">
			<div class="rtl-notice-title">خطای افزونه بروزرسان خودکار راست چین</div>
			<?php if ( version_compare( phpversion(), '7.2', '<') ) { ?>
				<p>برای اجرای افزونه <strong> بروزرسان خودکار راست چین </strong>  نیاز به php نسخه 7.2 به بالا دارید.</p>
				<span>نسخه فعلی php در هاست شما: <?php echo PHP_VERSION; ?></span>
			<?php } if ( !extension_loaded('ionCube Loader') || version_compare( ioncube_loader_version(), '10.2', '<') ) { ?>
				<p>برای اجرای افزونه <strong> بروزرسان خودکار راست چین </strong> می بایست آخرین نسخه ionCube Loader روی سرور شما نصب و فعال باشد.</p>
				<span>در این زمینه می بایست با پشتیبانی هاست خود در تماس باشید.</span>
			<?php } ?>
		</div>
	</div>
	<?php
}
register_activation_hook(__FILE__, array('RTL_Theme_class', 'install_plugin'));
register_deactivation_hook(__FILE__, array('RTL_Theme_class', 'deactivate_plugin'));